/*=========================================================================
 Program:   OsiriX
 Copyright (c) 2010 - 2024 Pixmeo SARL
 266 rue de Bernex
 CH-1233 Bernex
 Switzerland
 All rights reserved.
 =========================================================================*/

//#if defined( __x86_64__)
//#define USE_OSPRAY
//#endif

#import <AppKit/AppKit.h>
#import "DCMPix.h"

#ifdef __cplusplus
#import "VTKView.h"

#define id Id
#include "vtkCommand.h"
#include "vtkActor.h"
#include "vtkPolyData.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkVolume16Reader.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkOutlineFilter.h"
#include "vtkImageReader.h"
#include "vtkImageImport.h"
#include "vtkCamera.h"
#include "vtkStripper.h"
#include "vtkLookupTable.h"
#include "vtkImageDataGeometryFilter.h"
#include "vtkProperty.h"
#include "vtkPolyDataNormals.h"
#include "vtkContourFilter.h"
#include "vtkImageData.h"
#include "vtkImageMapToColors.h"
#include "vtkImageActor.h"
#include "vtkLight.h"
#include "vtkPlane.h"
#include "vtkPlanes.h"
#include "vtkPlaneSource.h"
#include "vtkBoxWidget.h"
#include "vtkPiecewiseFunction.h"
#include "vtkPiecewiseFunction.h"
#include "vtkColorTransferFunction.h"
#include "vtkVolumeProperty.h"
//#include "vtkVolumeRayCastCompositeFunction.h"
//#include "vtkVolumeRayCastMapper.h"
//#include "vtkVolumeRayCastMIPFunction.h"

#ifdef USE_OSPRAY
#include "vtkOSPRayVolumeMapper.h"
#endif

#include "vtkFixedPointVolumeRayCastMapper.h"
#include "vtkTransform.h"
#include "vtkSphere.h"
#include "vtkImplicitBoolean.h"
#include "vtkExtractGeometry.h"
#include "vtkDataSetMapper.h"
#include "vtkPicker.h"
#include "vtkCellPicker.h"
#include "vtkPointPicker.h"
#include "vtkLineSource.h"
#include "vtkPolyDataMapper2D.h"
#include "vtkActor2D.h"
#include "vtkExtractPolyDataGeometry.h"
#include "vtkProbeFilter.h"
#include "vtkCutter.h"
#include "vtkTransformPolyDataFilter.h"
#include "vtkXYPlotActor.h"
#include "vtkClipPolyData.h"
#include "vtkBox.h"
#include "vtkCallbackCommand.h"
#include "vtkLightKit.h"
#include "vtkTextActor.h"
#include "vtkCornerAnnotation.h"
#include "vtkTextProperty.h"
#include "vtkImageFlip.h"
#include "vtkAnnotatedCubeActor.h"
#include "vtkOrientationMarkerWidget.h"
//#include "vtkVolumeTextureMapper2D.h"
#include "vtkSmartVolumeMapper.h"
#include "vtkGPUVolumeRayCastMapper.h"
#include "vtkOsiriXFixedPointVolumeRayCastMapper.h"

#include "vtkCellArray.h"
#include "vtkProperty2D.h"
#include "vtkRegularPolygonSource.h"
#include "vtkInformation.h"
#include "vtkLightCollection.h"

#ifdef _STEREO_VISION_
// Added SilvanWidmer 10-08-09
// ****************************
#import	 "vtkCocoaGLView.h"
#include "vtkCocoaRenderWindowInteractor.h"
#include "vtkCocoaRenderWindow.h"
#include "vtkParallelRenderManager.h"
#include "vtkRendererCollection.h"
#include "vtkCallbackCommand.h"
#import	"VTKStereoVRView.h"
// ****************************
#endif

#undef id

class vtkMyCallbackVR;

#else

typedef char* vtkTransform;
typedef char* vtkImageActor;
typedef char* vtkImageMapToColors;
typedef char* vtkLookupTable;
typedef char* vtkImageReslice;
typedef char* vtkImageImport;
typedef char* vtkCamera;
typedef char* vtkActor;
typedef char* vtkPolyDataMapper;
typedef char* vtkOutlineFilter;
typedef char* vtkLineWidget;

typedef char* vtkTextActor;
typedef char* vtkCornerAnnotation;
typedef char* vtkVolumeMapper;

#ifdef USE_OSPRAY
typedef char* vtkOSPRayVolumeMapper;
#endif

typedef char* vtkFixedPointVolumeRayCastMapper;
typedef char* vtkOsiriXFixedPointVolumeRayCastMapper;
//typedef char* vtkVolumeRayCastMIPFunction;
typedef char* vtkVolume;


typedef char* vtkPiecewiseFunction;
//typedef char* vtkVolumeTextureMapper2D;
typedef char* vtkPolyData;
typedef char* vtkVolumeProperty;
typedef char* vtkPolyDataMapper2D;

typedef char* vtkColorTransferFunction;
typedef char* vtkActor2D;
typedef char* vtkMyCallback;
typedef char* vtkBoxWidget;
//typedef char* vtkVolumeRayCastCompositeFunction;

typedef char* vtkRenderer;
typedef char* vtkVolumeTextureMapper3D;
typedef char* vtkSmartVolumeMapper;
typedef char* vtkGPUVolumeRayCastMapper;
typedef char* vtkOrientationMarkerWidget;
typedef char* vtkRegularPolygonSource;

typedef char* vtkMyCallbackVR;
typedef char* vtkInformation;
typedef char* vtkLightCollection;
typedef char* vtkLightKit;

#ifdef _STEREO_VISION_
// ****************************
// Added SilvanWidmer 10-08-09
typedef char* vtkCocoaRenderWindowInteractor;
typedef char* vtkCocoaRenderWindow;
typedef char* vtkParallelRenderManager;
typedef	char* vtkRenderWindow;
typedef char* vtkRendererCollection;
typedef char* vtkCocoaGLView;
typedef char* vtkCallbackCommand;
typedef char* VTKStereoVRView;
// ****************************
#endif
#endif

#include <Accelerate/Accelerate.h>
#import "ViewerController.h"
#import "WaitRendering.h"

@class DICOMExport;
@class Camera;
@class VRController;
@class OSIVoxel;
@class ScreenCapture;

#import "CLUTOpacityView.h"

/** \brief  Volume Rendering View
*
*   View for volume rendering and MIP
*/
#ifdef __cplusplus
#else
#define VTKView NSView
#endif

@interface VRView : VTKView
{
	NSTimer						*autoRotate, *startAutoRotate;
	BOOL						isRotating, flyto;
	int							incFlyTo;
	
    int                         engine;
    
	float						flyToDestination[ 3];

	int							projectionMode;
    NSMutableArray				*blendingPixList;
    DCMPix						*blendingFirstObject;
    float						*blendingData, blendingFactor;
	ViewerController			*blendingController;
	char						*blendingData8;
	vImage_Buffer				blendingSrcf, blendingDst8;
	float						blendingWl, blendingWw, measureLength;
	vtkImageImport				*blendingReader;
	
	vtkOsiriXFixedPointVolumeRayCastMapper *blendingVolumeMapper;
	vtkGPUVolumeRayCastMapper	*blendingTextureMapper;
	
	vtkVolume					*blendingVolume;
	vtkVolumeProperty			*blendingVolumeProperty;
	vtkColorTransferFunction	*blendingColorTransferFunction;
//	vtkVolumeRayCastCompositeFunction *blendingCompositeFunction;
	vtkPiecewiseFunction		*blendingOpacityTransferFunction;
	double						blendingtable[257][3];
	
	BOOL						needToFlip, blendingNeedToFlip, firstTime, firstTimeCroppingBox, firstTimeCroppingBoxBlending, alertDisplayed;
	
	IBOutlet NSWindow			*export3DWindow;
	IBOutlet NSSlider			*framesSlider;
	IBOutlet NSMatrix			*quality, *rotation, *orientation;
	IBOutlet NSTextField		*pixelInformation;
    IBOutlet NSImageView        *viewRescaleButton;
    
	IBOutlet NSWindow			*exportDCMWindow;
	IBOutlet NSSlider			*dcmframesSlider;
	IBOutlet NSMatrix			*dcmExportMode, *dcmquality, *dcmrotation, *dcmorientation;
	IBOutlet NSBox				*dcmBox;
	IBOutlet NSMatrix			*dcmExportDepth;
	IBOutlet NSTextField		*dcmSeriesName;
	NSString					*dcmSeriesString;
	
	IBOutlet NSWindow       *export3DVRWindow;
	IBOutlet NSMatrix		*VRFrames;
	IBOutlet NSMatrix		*VRquality;
	
	IBOutlet NSMatrix		*scissorStateMatrix;
    IBOutlet NSColorWell    *backgroundColorWell;
    NSColor *backgroundColor;
	
	IBOutlet NSObjectController	*shadingController;
	
	long					numberOfFrames;
	BOOL					bestRenderingMode;
	float					rotationValue, factor;
	long					rotationOrientation, renderingMode;
	
	NSArray					*currentOpacityArray;
    NSMutableArray			*pixList;
    DCMPix					*firstObject;
    float					*data;
	
	float					valueFactor, blendingValueFactor;
	float					OFFSET16, blendingOFFSET16;
	
	unsigned char			*dataFRGB;
    BOOL                    ownData8;
	char					*data8;
	vImage_Buffer			srcf, dst8;

    ToolMode				currentTool, toolBeforeScreenCapture;
	float					wl, ww;
	float					LOD, lowResLODFactor, lodDisplayed;
	float					cosines[ 9];
	float					blendingcosines[ 9];
	double					table[257][3];
	double					alpha[ 257];

	NSCursor				*cursor;
	BOOL					cursorSet;
	
    int                     trackPadNumberOfFingers;
    float                   trackPadScaleAccumulator;
    BOOL                    trackPadMoved;

    
    vtkRenderer				*aRenderer;
    vtkCamera				*aCamera;

    vtkActor				*outlineRect;
    vtkPolyDataMapper		*mapOutline;
    vtkOutlineFilter		*outlineData;
	
	vtkMyCallbackVR				*cropcallback;
	vtkOrientationMarkerWidget	*orientationWidget;
	vtkBoxWidget				*croppingBox;
//	double						initialCroppingBoxBounds[6];
//	BOOL						dontUseAutoCropping;
	
	
	// MAPPERS
#ifdef USE_OSPRAY
    vtkOSPRayVolumeMapper       *osprayMapper;
#endif
    
	vtkOsiriXFixedPointVolumeRayCastMapper *volumeMapper;
	vtkGPUVolumeRayCastMapper		*textureMapper;
	
	vtkVolume					*volume;
	vtkVolumeProperty			*volumeProperty;
	vtkColorTransferFunction	*colorTransferFunction;
	vtkCornerAnnotation			*cornerText;
	BOOL						isViewportResizable;
	vtkImageImport				*reader;
//	vtkVolumeRayCastCompositeFunction  *compositeFunction;
	vtkPiecewiseFunction		*opacityTransferFunction;
	
	vtkColorTransferFunction	*red, *green, *blue;
	BOOL						noWaitDialog, isRGB, isBlendingRGB, ROIUPDATE;
	WaitRendering				*splash;
	
	double						camPosition[ 3], camFocal[ 3];
	
	NSMutableArray				*ROIPoints;
	
	vtkPolyData					*ROI3DData;
	vtkPolyDataMapper2D			*ROI3D;
	vtkActor2D					*ROI3DActor;
	
    double                      Line3DPt1[4], Line3DPt2[4];
	vtkActor2D					*Line2DActor;
	vtkTextActor				*Line2DText;
	
    vtkRegularPolygonSource		*Oval2DData;
	vtkPolyDataMapper2D			*Oval2D;
	vtkActor2D					*Oval2DActor;
	vtkTextActor				*Oval2DText;
    float                       Oval2DCos[ 9], Oval2DPosition[ 3];
    DCMPix                      *Oval2DPix;
    
    NSPoint                     Oval2DCenter, WorldOval2DCenter;
    double                      Oval2DRadius;
    
    double                      Oval2DSampleDistance;
    int                         Oval2DPixZBufferOrigin[2];
    
	BOOL						clamping;
	
	DICOMExport					*exportDCM;
	
	NSMutableArray				*point3DActorArray;
	NSMutableArray				*point3DPositionsArray;
	NSMutableArray				*point3DRadiusArray;
	NSMutableArray				*point3DColorsArray;
	BOOL						display3DPoints;
	IBOutlet NSPanel			*point3DInfoPanel;
	IBOutlet NSSlider			*point3DRadiusSlider;
	IBOutlet NSColorWell		*point3DColorWell;
	IBOutlet NSButton			*point3DPropagateToAll, *point3DSetDefault;
	IBOutlet VRController		*controller;
	float						point3DDefaultRadius, point3DDefaultColorRed, point3DDefaultColorGreen, point3DDefaultColorBlue, point3DDefaultColorAlpha;
	
	BOOL						_dragInProgress;
	NSTimer						*_mouseDownTimer, *_rightMouseDownTimer;
	NSImage						*destinationImage;
	
	NSPoint						_mouseLocStart, _previousLoc;  // mouseDown start point
	BOOL						_resizeFrame;
	ToolMode					_tool;
	
	float						_startWW, _startWL, _startMin, _startMax;
	
	NSRect						savedViewSizeFrame;
	
	float						firstPixel, secondPixel;
	
	NSLock						*deleteRegion;
	
	IBOutlet CLUTOpacityView	*clutOpacityView;
	BOOL						advancedCLUT;
	NSData						*appliedCurves;
	BOOL						appliedResolution;
	BOOL						gDataValuesChanged;

	float						verticalAngleForVR;
	float						rotateDirectionForVR;
	
	BOOL						_contextualMenuActive;
	
	//Context for rendering to iChat
	BOOL						_hasChanged;
	float						iChatWidth, iChatHeight;
	BOOL						iChatFrameIsSet;
	
	// 3DConnexion SpaceNavigator
	NSTimer			*snCloseEventTimer;
	BOOL			snStopped;
	UInt16			snConnexionClientID;
	
	BOOL			clipRangeActivated;
	double			clippingRangeThickness;
	
	BOOL			bestRenderingWasGenerated;
	float superSampling;
	BOOL dontResetImage, keep3DRotateCentered;
	int fullDepthMode, fullDepthEngineCopy;
	
#ifdef _STEREO_VISION_
	//Added SilvanWidmer 10-08-09
	NSWindow						*LeftFullScreenWindow; 
	NSWindow						*RightFullScreenWindow;   
	BOOL							StereoVisionOn;
	vtkCocoaGLView					*leftView;
	VTKStereoVRView					*rightView;
	NSWindow						*rootWindow;
	NSView							*LeftContentView;
	NSRect							rootSize;
	NSSize							rootBorder;
	vtkCallbackCommand				*rightResponder;
#endif
    
    
    IBOutlet NSPanel *ospraySettingsPanel;
    
    int ospraySPP, osprayAmbientSamples;
    BOOL osprayComposite, willHaveToReActivateOSPRay, denoise;
    float scalarOpacityUnitDistance, osprayLightScale, viewAngle, focalDistancePoint[ 3];
    double focalDistance, focalDisk;
    
    BOOL maintainLuminace;
    double keyWarm, keyInt, keyEle, keyAzi;
    double backWarm, backKB, backEle, backAzi;
    double fillWarm, fillKF, fillEle, fillAzi;
    double headWarm, headKH;
    
    double volumetricScatteringBlending, globalIlluminationReach;
    
    vtkLightKit *lightKit;
    
    NSColor *keyLightColor, *fillLightColor, *headLightColor, *backLightColor;
    
    IBOutlet NSPopUpButton *presetsPopup;
    IBOutlet NSWindow *presetWindow;
    IBOutlet NSTextField *presetName;
    
    BOOL cinematicRenderingActived;
    
    NSPoint ROISelectorStartPoint, ROISelectorEndPoint;
}

#ifdef _STEREO_VISION_
@property(readwrite) BOOL StereoVisionOn; 
//@property(readonly) short currentTool;
#endif

@property BOOL cinematicRenderingActived, showAnnotations;
@property (nonatomic) BOOL clipRangeActivated, keep3DRotateCentered, dontResetImage, bestRenderingMode, osprayComposite, denoise;
@property (nonatomic) int projectionMode, ospraySPP, osprayAmbientSamples;
@property (nonatomic) double clippingRangeThickness, focalDistance, focalDisk;
@property (nonatomic) float lowResLODFactor, lodDisplayed, scalarOpacityUnitDistance, osprayLightScale, viewAngle;
@property long renderingMode;
@property (nonatomic) int engine;
@property (readonly) NSArray* currentOpacityArray;
@property (readonly) NSImageView *viewRescaleButton;
@property (retain) DICOMExport *exportDCM;
@property (retain) NSString *dcmSeriesString, *upperLeft, *lowerRight;
@property (retain) ViewerController *blendingController;
@property (retain, nonatomic) NSColor *backgroundColor;
@property (retain, nonatomic) NSColor *keyLightColor, *fillLightColor, *headLightColor, *backLightColor;

@property (nonatomic) BOOL maintainLuminace;
@property (nonatomic) double keyWarm, keyInt, keyEle, keyAzi;
@property (nonatomic) double backWarm, backKB, backEle, backAzi;
@property (nonatomic) double fillWarm, fillKF, fillEle, fillAzi;
@property (nonatomic) double headWarm, headKH;
@property (nonatomic) double volumetricScatteringBlending, globalIlluminationReach;
@property(retain) ScreenCapture *screenCapture;
@property int trackPadNumberOfFingers;

+ (BOOL) exportAsVTI:(NSArray*)pixList volumeData:(float*) volumeData path:(NSString*) file;
+ (void) addLogo: (unsigned char*) buf rowBytes: (unsigned int) rowBytes height: (unsigned int) height;
+ (void) testGraphicBoard;
+ (BOOL) getCroppingBox:(double*) a :(vtkVolume *) volume :(vtkBoxWidget*) croppingBox;
//+ (void) setCroppingBox:(double*) a :(vtkVolume *) volume;
//- (void) setBlendingCroppingBox:(double*) a;
//- (void) setCroppingBox:(double*) a;
//- (BOOL) croppingBox:(double*) a;
- (void) showCropCube:(id) sender;
- (void) restoreFullDepthCapture;
- (void) prepareFullDepthCapture;
- (VRController*) controller;
- (float*) imageInFullDepthWidth: (long*) w height:(long*) h isRGB:(BOOL*) isRGB;
- (float*) imageInFullDepthWidth: (long*) w height:(long*) h isRGB:(BOOL*) rgb blendingView:(BOOL) blendingView;
- (NSDictionary*) exportDCMCurrentImage;
- (NSDictionary*) exportDCMCurrentImageIn16bit: (BOOL) fullDepth;
- (NSDictionary*) exportDCMCurrentImageIn16bit: (BOOL) fullDepth display: (BOOL) display;
- (void) renderImageWithBestQuality: (BOOL) best waitDialog: (BOOL) wait;
- (void) renderImageWithBestQuality: (BOOL) best waitDialog: (BOOL) wait display: (BOOL) display;
- (void) endRenderImageWithBestQuality;
- (void) resetAutorotate:(id) sender;
- (void) setEngine: (long) engineID showWait:(BOOL) showWait;
- (IBAction)changeColorWith:(NSColor*) color;
- (void)changeColorWith:(NSColor*) color setNeedsDisplay: (BOOL) setNeedsDisplay;
- (IBAction)changeColor:(id)sender;
- (void) exportDICOM;
-(unsigned char*) getRawPixels:(long*) width :(long*) height :(long*) spp :(long*) bpp :(BOOL) screenCapture :(BOOL) force8bits;
-(unsigned char*) getRawPixels:(long*) width :(long*) height :(long*) spp :(long*) bpp :(BOOL) screenCapture :(BOOL) force8bits offset:(int*) offset isSigned:(BOOL*) isSigned;
-(void) set3DStateDictionary:(NSDictionary*) dict;
-(NSMutableDictionary*) get3DStateDictionary;
- (void) setBlendingEngine: (long) engineID;
- (void) setBlendingEngine: (long) engineID showWait:(BOOL) showWait;
- (void) getShadingValues:(float*) ambient :(float*) diffuse :(float*) specular :(float*) specularpower;
- (void) setShadingValues:(float) ambient :(float) diffuse :(float) specular :(float) specularpower;
-(void) movieChangeSource:(float*) volumeData;
-(void) movieChangeSource:(float*) volumeData showWait :(BOOL) showWait;
-(void) movieBlendingChangeSource:(long) index;
-(void) setBlendingWLWW:(float) iwl :(float) iww;
-(void) setBlendingCLUT:( unsigned char*) r : (unsigned char*) g : (unsigned char*) b;
-(void) setBlendingFactor:(float) a;
//-(NSDate*) startRenderingTime;
//-(void) newStartRenderingTime;
//-(void) deleteStartRenderingTime;
-(void) setOpacity:(NSArray*) array;
- (void) setLowResolutionCamera: (Camera*) cam;
//-(void) runRendering;
//-(void) startRendering;
//-(void) stopRendering;
//- (void) autoCroppingBox;
- (float) LOD;
-(void) setLOD:(float)f;
-(void) setCurrentTool:(ToolMode) i;
- (ToolMode) currentTool;
- (ToolMode) _tool;
//- (void) resetCroppingBox;
-(id)initWithFrame:(NSRect)frame;
-(short) setPixSource:(NSMutableArray*)pix :(float*) volumeData;
-(void) setCornerAnnotationsVisible: (BOOL) v;
- (void) setVolumeVisible: (BOOL) v;
-(short) setPixSource:(NSMutableArray*)pix volumeData:(float*) volumeData volumeData8: (char*) volumeData8 offset: (float) offset valueFactor: (float) vf;
-(void)dealloc;
//Fly to point in world coordinates;
- (void) flyTo:(float) x :(float) y :(float) z;
// Fly to Volume Point 
- (void) flyToVoxel:(OSIVoxel *)voxel;
//Fly to 2D position on a slice;
- (void) flyToPoint:(NSPoint)point  slice:(int)slice;
- (void) processFlyTo;
- (void) setWLWW:(float) wl :(float) ww;
- (void) getWLWW:(float*) wl :(float*) ww;
- (void) getBlendingWLWW:(float*) iwl :(float*) iww;
- (void) setBlendingPixSource:(ViewerController*) bC;
- (IBAction) endQuicktimeSettings:(id) sender;
- (IBAction) endDCMExportSettings:(id) sender;
//- (IBAction) endQuicktimeVRSettings:(id) sender;
- (IBAction) exportQuicktime :(id) sender;
- (float) rotation;
- (float) numberOfFrames;
- (void) Azimuth:(float) z;
- (void) Vertical:(float) z;
- (NSImage*) nsimageQuicktime;
- (NSImage*) nsimage:(BOOL) q __deprecated;
- (NSImage*) nsimage;
- (void) setCLUT:( unsigned char*) r : (unsigned char*) g : (unsigned char*) b;
- (void)activateShading:(BOOL)on;
- (IBAction) switchShading:(id) sender;
- (long) shading;
- (BOOL) isOSPRayEnabled;
- (void) setEngine: (int) engineID;
- (void) setProjectionMode: (int) mode;
- (IBAction) resetImage:(id) sender;
- (void) saView:(id) sender;
- (IBAction)setRenderMode:(id)sender;
- (void) setBlendingMode: (long) modeID;
- (NSImage*) nsimageQuicktime:(BOOL) renderingMode;
- (vtkRenderer*) vtkRenderer;
- (vtkCamera*) vtkCamera;
- (void) setVtkCamera:(vtkCamera*)aVtkCamera;
- (void)setCenterlineCamera: (Camera *) cam;
- (void) setCamera: (Camera*) cam;
- (Camera*) camera;
- (Camera*) cameraWithThumbnail:(BOOL) produceThumbnail;
- (IBAction) scissorStateButtons:(id) sender;
- (void) updateScissorStateButtons;
- (void) switchOrientationWidget:(id) sender;
-(void) setOrientationWidgetVisible: (BOOL) v;
- (void) computeOrientationText;
- (void) getOrientation: (float*) o;
- (void) bestRendering:(id) sender;
- (void) setMode: (long) modeID;
- (long) mode;
- (float) scaleFactor;
- (double) getResolution;
- (BOOL) getCosMatrix: (float *) cos;
- (void) getOrigin: (float *) origin;
- (void) getOrigin: (float *) origin windowCentered:(BOOL) wc;
- (void) getOrigin: (float *) origin windowCentered:(BOOL) wc sliceMiddle:(BOOL) sliceMiddle;
- (void) getOrigin: (float *) origin windowCentered:(BOOL) wc sliceMiddle:(BOOL) sliceMiddle blendedView:(BOOL) blendedView;
- (BOOL) isViewportResizable;
- (void) setViewportResizable: (BOOL) boo;
- (void) scrollInStack: (float) delta;

- (void) rightMouseDragged:(NSEvent *)theEvent backingScaleFactor: (float) backingScaleFactor;
- (void) mouseDown:(NSEvent *)theEvent backingScaleFactor: (float) backingScaleFactor;
- (void) mouseDragged:(NSEvent *)theEvent backingScaleFactor: (float) backingScaleFactor;
- (void) rightMouseDown:(NSEvent *)theEvent backingScaleFactor: (float) backingScaleFactor;

- (float) SIOrientationInDegrees;
- (float) LROrientationInDegrees;
- (float) RollOrientationInDegrees;

// 3D Points
- (BOOL) get3DPixelUnder2DPositionX:(float) x Y:(float) y pixel: (long*) pix position:(float*) position value:(float*) val;
- (BOOL) get3DPixelUnder2DPositionX:(float) x Y:(float) y pixel: (long*) pix position:(float*) position value:(float*) val maxOpacity: (float) maxOpacity minValue: (float) minValue;

- (void) add3DPoint: (double) x : (double) y : (double) z : (float) radius : (float) r : (float) g : (float) b;
- (void) add3DPoint: (double) x : (double) y : (double) z;
- (void) add3DPointActor: (vtkActor*) actor;
- (void) addRandomPoints: (int) n : (int) r;
- (void) throw3DPointOnSurface: (double) x : (double) y;
- (void) setDisplay3DPoints: (BOOL) on;
- (void) toggleDisplay3DPoints;
- (BOOL) isAny3DPointSelected;
- (unsigned int) selected3DPointIndex;
- (void) unselectAllActors;
- (void) remove3DPointAtIndex: (unsigned int) index;
- (void) removeSelected3DPoint;
- (IBAction) IBSetSelected3DPointColor: (id) sender;
- (IBAction) IBSetSelected3DPointRadius: (id) sender;
- (IBAction) IBPropagate3DPointsSettings: (id) sender;
- (void) setSelected3DPointColor: (NSColor*) color;
- (void) setAll3DPointsColor: (NSColor*) color;
- (void) set3DPointAtIndex:(unsigned int) index Color: (NSColor*) color;
- (void) setSelected3DPointRadius: (float) radius;
- (void) setAll3DPointsRadius: (float) radius;
- (void) set3DPointAtIndex:(unsigned int) index Radius: (float) radius;
- (IBAction) save3DPointsDefaultProperties: (id) sender;
- (void) load3DPointsDefaultProperties;
- (void) convert3Dto2Dpoint:(double*) pt3D :(double*) pt2D;
- (void)convert2DPoint:(float *)pt2D to3DPoint:(float *)pt3D;
- (IBAction) setCurrentdcmExport:(id) sender;
- (IBAction) switchToSeriesRadio:(id) sender;
- (float) offset;
- (float) valueFactor;
- (void) squareView:(id) sender;
- (void) computeValueFactor;
- (void) setRotate: (BOOL) r;
- (float) factor;
- (float) OpenGlBackingScaleFactor;
- (float) imageSampleDistance;
- (float) blendingImageSampleDistance;
- (void) setViewSizeToMatrix3DExport;
- (void) restoreViewSizeAfterMatrix3DExport;
- (void) axView:(id) sender;
- (void) coView:(id) sender;
- (void) saViewOpposite:(id) sender;
- (void) render;
- (void) renderBlendedVolume;
- (void) goToCenter;
- (void)zoomMouseUp:(NSEvent *)theEvent;
- (void) setWindowCenter: (NSPoint) loc;
- (NSPoint) windowCenter;
- (double) getClippingRangeThickness;
- (double) getClippingRangeThicknessInMm;
- (void) setClippingRangeThicknessInMm:(double) c;
- (void) setLODLow:(BOOL) l;

// export
- (void) sendMail:(id) sender;
- (void) exportJPEG:(id) sender;
- (void) export2iPhoto:(id) sender;
- (void) exportTIFF:(id) sender;

// cursors
-(void) setCursorForView: (long) tool;

//Dragging
- (void) startDrag:(NSTimer*)theTimer;
- (void)deleteMouseDownTimer;

//Menus
- (void)deleteRightMouseDownTimer;

-(BOOL)actionForHotKey:(NSString *)hotKey;
- (void)setAdvancedCLUT:(NSMutableDictionary*)clut lowResolution:(BOOL)lowRes;
- (void)setAdvancedCLUTWithName:(NSString*)name;
- (BOOL)advancedCLUT;
- (BOOL)isRGB;

- (vtkVolumeMapper*) mapper;
- (void)setMapper: (vtkVolumeMapper*) mapper;
- (vtkVolume*)volume;
- (void)setVolume:(vtkVolume*)aVolume;
- (char*)data8;
- (void)setData8:(char*)data;

- (void)drawImage:(NSImage *)image inBounds:(NSRect)rect;
- (BOOL)checkHasChanged;
- (void)setIChatFrame:(BOOL)boo;
//- (void)_iChatStateChanged:(NSNotification *)aNotification;

- (void)yaw:(float)degrees;
- (void)roll:(float)degrees;
- (void)pitch:(float)degrees;
- (void)panX:(double)x Y:(double)y;

- (void)recordFlyThru;

// 3DConnexion SpaceNavigator
- (void)connect2SpaceNavigator;
void VRSpaceNavigatorMessageHandler(io_connect_t connection, natural_t messageType, void *messageArgument);

#ifdef _STEREO_VISION_
//Added SilvanWidmer 27-08-09
- (long) getTool: (NSEvent*) event;
- (void) computeLength;
- (void) generateROI;
#endif

@end
